C      *****************************************************************
C      * Subroutine IndSort                                            *
C      * Perform an indexed ascending sort on an integer array.  The   *
C      * indices array is changed, not the array to be ordered.        *
C      *                                                               *
C      * Variables:                                                    *
C      * N         -Local - Array index.  Unitless.                    *
C      * IArray    -Input - An integer array to sort over.  Units      *
C      *                    consistent with input.                     *
C      * Index     -In/Out- Input as an integer array of increasing    *
C      *                    indices from one to NItems. Output as the  *
C      *                    sorted order of IArray.  Unitless.         *
C      * NItems    -Input - Number of elements in list (which is       *
C      *                    assumed to begin with element one).        *
C      *                    Unitless.                                  *
C      * OutOfOrder-Local - Boolean flag to indicate when done.        *
C      *                    Unitless.                                  *
C      *****************************************************************
       SUBROUTINE INDSORT(IARRAY, INDEX, NITEMS)
							IMPLICIT NONE
       INCLUDE 'ARRAYSIZES.INC'
       INTEGER IARRAY(NSPECIESSIZE), INDEX(NSPECIESSIZE), N, NITEMS
      
       LOGICAL OUTOFORDER

  100  CONTINUE
          OUTOFORDER = .FALSE.
          DO 110 N = 1, NITEMS-1
             IF (IARRAY(INDEX(N)).GT.IARRAY(INDEX(N+1))) THEN
                CALL SWAP(INDEX(N), INDEX(N+1))
                OUTOFORDER = .TRUE.
             ENDIF
  110     CONTINUE
       IF (OUTOFORDER) GOTO 100
             
	      RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
